<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Locator extends CI_Controller {
    function __construct(){
		parent::__construct();
        $this->load->model('Model_category');
        $this->load->model('Model_store');
        
		$this->load->model('Model_setting', 'setting');
	}

	// store locator page
	public function index(){
		$get = $this->input->get();

		// get all cateogories for side menu
		$meta['categories'] = $this->Model_category->getAllActiveCategory();
		
		$data = array();

		// when category selected then get category information to dispalyand get store
		if(isset($get['cats'])){
			$getCategory = $this->Model_category->getCategoryById($get['cats']);
			$data['category_info'] = $getCategory;
			$get['category_id'] = $get['cats'];
		}
		// dd($data);
		
		// filter data if available we use to filter store 
		$data['latitude'] = isset($get['latitude']) ? $get['latitude'] : '';
		$data['longitude'] = isset($get['longitude']) ? $get['longitude'] : '';
		$data['postal_code'] = isset($get['postal_code']) ? $get['postal_code'] : '';
		$data['keyword'] = isset($get['keyword']) ? $get['keyword'] : '';
		$data['location'] = isset($get['location']) ? $get['location'] : '';
		$data['category_id'] = isset($get['category_id']) ? $get['category_id'] : '';
		$data['stores'] = array();
		$data['keyword_search'] = false;

		$allSetting = $this->setting->getAllSetting();
		// if user comes here from keyword then only this will apply
		if(count($get) > 2){
			$data['keyword_search'] = true;
			$get['page_no'] = 1;
			$get['search_radius'] = $allSetting['max_search_radius'];
			$data['stores'] = $this->Model_store->filterStore($get);	
			$this->Model_store->searchLog($get);
		}
		
		// get setting value for map default location and zoom
		
		$map_center = json_decode($allSetting['map_center'], true);

		$meta['default_lat'] = $map_center['lat'];
		$meta['default_lng'] = $map_center['lng'];
		$meta['default_zoom'] = $map_center['zoom'];
		$meta['page_class'] = 'locator-page';
		$meta['preloader'] = false;
        // dd($data);
		$this->load->view('frontend/common/header', $meta);
		$this->load->view('frontend/locator', $data);
		$this->load->view('frontend/common/footer', $meta);
	}

	
	// search store
	public function findStore(){
		$post = $this->input->post();
		$post['page_no'] = $_GET['page_no'];
		$this->Model_store->searchLog($post);
		$allSetting = $this->setting->getAllSetting();
		$post['search_radius'] = $allSetting['max_search_radius'];
		$stores = $this->Model_store->filterStore($post);
		$totalStore = $this->Model_store->countTotalRecord($post);
		// dd($totalStore);
		$allStores = $todayTime = array();
		foreach ($stores as $key => $store) {
			$cats = $categories = array();
			$storeCategories = $this->Model_store->getStoreCategory($store['store_id']);
	        foreach($storeCategories as $category){
	            $getCategory = $this->Model_category->getCategoryById($category['category_id']);
	            $categories[] = $getCategory;
	            $cats[] = $category['category_id'];
	        }
	        $store['cats'] = $cats;
        	$store['categories'] = $categories;

			$storeTime = $this->Model_store->getStoreTime($store['store_id']);
			$store['all_time'] = $storeTime;

			$timming = $this->Model_store->getCurrentStoreStatus($store['store_id'], $store['store_timezone']);
			$store['timming'] = $timming;

			$holiday = $this->Model_store->checkForStoreHoliday($store['store_id']);
			$store['holiday'] = $holiday;
			$allStores[] = $store;
		}
		// dd($allStores);
		$data['stores'] = $allStores;
		$data['total_store'] = $totalStore; 
		$data['search_radius'] = $allSetting['max_search_radius'];
		// $data['current_page'] = $post['page_no'];
		$viewHtml = $this->load->view('frontend/ajax/locator', $data, true);
		echo json_encode($viewHtml);
	}

	// store locator page
	public function v3(){
		$get = $this->input->get();

		// get all cateogories for side menu
		$meta['categories'] = $this->Model_category->getAllActiveCategory();
		
		$data = array();

		// when category selected then get category information to dispalyand get store
		if(isset($get['cats'])){
			$getCategory = $this->Model_category->getCategoryById($get['cats']);
			$data['category_info'] = $getCategory;
			$get['category_id'] = $get['cats'];
		}
		// dd($data);
		
		// filter data if available we use to filter store 
		$data['latitude'] = isset($get['latitude']) ? $get['latitude'] : '';
		$data['longitude'] = isset($get['longitude']) ? $get['longitude'] : '';
		$data['postal_code'] = isset($get['postal_code']) ? $get['postal_code'] : '';
		$data['keyword'] = isset($get['keyword']) ? $get['keyword'] : '';
		$data['location'] = isset($get['location']) ? $get['location'] : '';
		$data['category_id'] = isset($get['category_id']) ? $get['category_id'] : '';
		$data['stores'] = array();
		$data['keyword_search'] = false;

		$allSetting = $this->setting->getAllSetting();
		// if user comes here from keyword then only this will apply
		if(count($get) > 2){
			$data['keyword_search'] = true;
			$get['page_no'] = 1;
			$get['search_radius'] = $allSetting['max_search_radius'];
			$data['stores'] = $this->Model_store->filterStore($get);	
			$this->Model_store->searchLog($get);
		}
		
		// get setting value for map default location and zoom
		
		$map_center = json_decode($allSetting['map_center'], true);

		$meta['default_lat'] = $map_center['lat'];
		$meta['default_lng'] = $map_center['lng'];
		$meta['default_zoom'] = $map_center['zoom'];
		$meta['page_class'] = 'locator-page';
        // dd($data);
		$this->load->view('frontend/common/header', $meta);
		$this->load->view('frontend/v3/locator', $data);
		$this->load->view('frontend/common/footer', $meta);
	}

	
	// search store
	public function findStore_v3(){
		$post = $this->input->post();
		$post['page_no'] = $_GET['page_no'];
		$this->Model_store->searchLog($post);
		$allSetting = $this->setting->getAllSetting();
		$post['search_radius'] = $allSetting['max_search_radius'];
		$stores = $this->Model_store->filterStore($post);
		$totalStore = $this->Model_store->countTotalRecord($post);
		// dd($totalStore);
		$allStores = $todayTime = array();
		foreach ($stores as $key => $store) {

			$storeCategories = $this->Model_store->getStoreCategory($store['store_id']);
	        foreach($storeCategories as $category){
	            $getCategory = $this->Model_category->getCategoryById($category['category_id']);
	            $categories[] = $getCategory;
	            $cats[] = $category['category_id'];
	        }
	        $store['cats'] = $cats;
        	$store['categories'] = $categories;

			$storeTime = $this->Model_store->getStoreTime($store['store_id']);
			$store['all_time'] = $storeTime;

			$timming = $this->Model_store->getCurrentStoreStatus($store['store_id'], $store['store_timezone']);
			$store['timming'] = $timming;

			$holiday = $this->Model_store->checkForStoreHoliday($store['store_id']);
			$store['holiday'] = $holiday;
			$allStores[] = $store;
		}
		// dd($allStores);
		$data['stores'] = $allStores;
		$data['total_store'] = $totalStore; 
		$data['search_radius'] = $allSetting['max_search_radius'];
		// $data['current_page'] = $post['page_no'];
		$viewHtml = $this->load->view('frontend/v3/ajax/locator', $data, true);
		echo json_encode($viewHtml);
	}
	
	// one store detail on cliking view store btn
	public function storeDetail(){
		$post = $this->input->post();
		$store = $this->Model_store->getStoreById($post['store_id']);

		// Get Store All Timming
		$storeTime = $this->Model_store->getStoreTime($store['store_id']);
		$store['all_time'] = $storeTime;
		// echo date_default_timezone_get();

		// Check for store holiday on today
		$holiday = $this->Model_store->checkForStoreHoliday($store['store_id']);
		$store['holiday'] = $holiday;

		// Get Store Today timming
		$todayTime = $this->Model_store->getCurrentStoreStatus($store['store_id'], $store['store_timezone']);
		$store['today_time'] = $todayTime;

		// dd($store);
		$data['store'] = $store;
		$viewHtml = $this->load->view('frontend/ajax/store_view', $data, true);
		echo json_encode($viewHtml);
	}

	// keyword search page
	public function keyword(){
		$data = array();
		$data['categories'] = $this->Model_category->getAllActiveCategory();
		$this->load->view('frontend/common/header');
		$this->load->view('frontend/keyword', $data);
		$this->load->view('frontend/common/footer');
	}
}
