<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Model_store extends CI_Model
{
    public function insertGeneralInfo($data){
        $store_id = $this->uuid->v4();
        $storeInsert = array(
            'store_id' => $store_id,
            'name' => $data['name'],
            'user_id' => $data['user_id'],
            'email' => $data['email'],
            'website' => $data['website'],
            'phone' => $data['phone'],
            'fax' => $data['fax'],
            'status' => $data['status'],
            'description' => $data['description'],
            'create_date' => date(DATE_FORMAT_DB)
        );
        
        $this->db->insert(TBL_STORE, $storeInsert);
        return $store_id;
    }
    public function updateGeneralInfo($data){
        // dd($data);
        $storeInsert = array(
            'name' => $data['name'],
            'user_id' => $data['user_id'],
            'email' => $data['email'],
            'website' => $data['website'],
            'phone' => $data['phone'],
            'fax' => $data['fax'],
            'status' => $data['status'],
            'description' => $data['description'],
        );
        $this->db->where('store_id', $data['store_id']);
        $this->db->update(TBL_STORE, $storeInsert);
        return $data['store_id'];
    }
    
    public function updateSocial($data){
        
        $storeInsert = array(
            'twitter' => $data['twitter'],
            'youtube' => $data['youtube'],
            'linkedin' => $data['linkedin'],
            'pinterest' => $data['pinterest'],
            'facebook' => $data['facebook'],
            'instagram' => $data['instagram'],
        );
        $this->db->where('store_id', $data['store_id']);
        $this->db->update(TBL_STORE, $storeInsert);
        return $data['store_id'];
    }
    public function updateLocation($data){
        $storeInsert = array(
            'address' => $data['address'],
            'city' => $data['city'],
            'state' => $data['state'],
            'postal_code' => $data['postal_code'],
            'country' => $data['country'],
            'latitude' => $data['latitude'],
            'longitude' => $data['longitude'],
        );
        $this->db->where('store_id', $data['store_id']);
        $this->db->update(TBL_STORE, $storeInsert);
        return $data['store_id'];
    }
    public function updateCategories($data){
        /* $storeInsert = array(
            'categories' => implode(',', $data['categories']),
        ); */
        $this->db->delete(TBL_STORE_CATEGORY, ['store_id' => $data['store_id']]);

        foreach($data['categories'] as $category){
            $storeCategory[] = array(
                'store_id' => $data['store_id'],
                'category_id' => $category
            );
        }

        $this->db->insert_batch(TBL_STORE_CATEGORY, $storeCategory);
        /* $this->db->where('store_id', $data['store_id']);
        $this->db->insert(TBL_STORE_CATEGORY, $storeInsert); */
        return $data['store_id'];
    }
    public function updateAdditionalInfo($data){
        $storeInsert = array(
            'additional_info' => $data['additional_info'],
            'image' => $data['image'],
        );
        $this->db->where('store_id', $data['store_id']);
        $this->db->update(TBL_STORE, $storeInsert);
        return $data['store_id'];
    }
    public function importCsv($data){
        $this->db->insert_batch(TBL_STORE, $data);
        return true;
    }
    // Admin View Functoins
    public function getListRecord($start,$no_of_rec,$data){
        $this->db->select('*');
        $this->db->from(TBL_STORE);
        
        if($data['store_id'] != ''){
            $this->db->where(TBL_STORE.'.store_id', $data['store_id']);
        }
        if($data['create_date'] != ''){
            $this->db->where('CAST('.TBL_STORE.'.create_date as date)=', date('Y-m-d',strtotime( str_replace('/', '-', $data['create_date']))));
        }
        if($data['status'] != ''){
            $this->db->where(TBL_STORE.'.status', $data['status']);
        }
        if(isset($data['user_id']) && $data['user_id'] != ''){
            $this->db->where(TBL_STORE.'.user_id', $data['user_id']);
        }
        $this->db->order_by('id', "DESC");
        $this->db->limit($no_of_rec,$start);
        $data = $this->db->get();
        // echo $this->db->last_query(); die;
        return  $data->result_array();
    }
    public function countAllRecord($data){
        $this->db->select('*');
        $this->db->from(TBL_STORE);
        
        if($data['store_id'] != ''){
            $this->db->where(TBL_STORE.'.store_id', $data['store_id']);
        }
        if($data['create_date'] != ''){
            $this->db->where('CAST('.TBL_STORE.'.create_date as date)=', date('Y-m-d',strtotime( str_replace('/', '-', $data['create_date']))));
        }
        if($data['status'] != ''){
            $this->db->where(TBL_STORE.'.status', $data['status']);
        }
        if(isset($data['user_id']) && $data['user_id'] != ''){
            $this->db->where(TBL_STORE.'.user_id', $data['user_id']);
        }
        return $this->db->count_all_results();
    }
    public function searchStoreByName($name, $user_id = ''){
        $this->db->select('name as text, store_id as id');
        if($name != ''){
            $this->db->like(TBL_STORE.'.name', $name);
        }
        if($user_id != ''){
            $this->db->where(TBL_STORE.'.user_id', $user_id);
        }
        $this->db->from(TBL_STORE)->limit(10);
        $data = $this->db->get();
        return  $data->result();
    }

    public function getStoreCategory($store_id){
        $this->db->select('*');
        $this->db->from(TBL_STORE_CATEGORY);
        $this->db->where('store_id', $store_id);
        $query = $this->db->get();
        return $query->result_array();
    }
    public function getStoreById($store_id){
        // CASE WHEN image_type = 1 THEN image ELSE IF(image != "", CONCAT("'.UPLOAD_URL.'",image), "'.ASSETS_URL.'no-image.jpg") END;
        // $this->db->select('*, image AS _image, CASE WHEN image_type = 1 THEN image ELSE IF(image != "", CONCAT("'.UPLOAD_URL.'",image), "'.ASSETS_URL.'no-image.jpg") END AS image');
        $this->db->select('*, image AS _image, (CASE WHEN image_type = 1 THEN image ELSE IF(image != "", CONCAT("'.UPLOAD_URL.'",image), "'.ASSETS_URL.'no-image.jpg") END) AS image');
        $this->db->where(TBL_STORE.'.store_id', $store_id);
        $this->db->from(TBL_STORE);
        $query = $this->db->get();
        $storeInfo = $query->row_array();

        $cats = $categories = array();
        
        $storeCategories = $this->getStoreCategory($store_id);
        foreach($storeCategories as $category){
            $getCategory = $this->Model_category->getCategoryById($category['category_id']);
            // echo $this->db->last_query(); 
            $categories[] = $getCategory;
            $cats[] = $category['category_id'];
        }

        $storeInfo['cats'] = $cats;
        $storeInfo['categories'] = $categories;
        // dd($storeInfo);
        return  $storeInfo;
    }
    public function getAllActiveStore(){
        $this->db->select('name, store_id');
        $this->db->from(TBL_STORE)->where('status', 1);
        $data = $this->db->get();
        return  $data->result_array();
    }
    public function remove($store_id){
        $this->db->where('store_id', $store_id);
        $this->db->delete(TBL_STORE);
        return true;
    }
    public function filterStore($data = array()){

        $limit = RECORD_LIMIT;
		$offset = $limit * ($data['page_no']-1); 

        $this->db->select('*, image AS _image, (CASE WHEN image_type = 1 THEN image ELSE IF(image != "", CONCAT("'.UPLOAD_URL.'",image), "'.ASSETS_URL.'no-image.jpg") END) AS image');
        
        if(isset($data['keyword']) && $data['keyword'] != ''){
            $where = '('.TBL_STORE.'.name LIKE "%'.$data['keyword'].'%" OR '.TBL_STORE.'.additional_info LIKE "%'.$data['keyword'].'%" OR '.TBL_STORE.'.description LIKE "%'.$data['keyword'].'%")';
            $this->db->where($where);
        }

        if(isset($data['latitude']) && isset($data['latitude'])){
            $this->db->select('ROUND( ( 6373 * acos( cos( radians('.$data['latitude'].') ) * cos( radians( '.TBL_STORE.'.latitude ) ) * cos( radians( '.TBL_STORE.'.longitude ) - radians('.$data['longitude'].') ) + sin( radians('.$data['latitude'].') ) * sin( radians( '.TBL_STORE.'.latitude ) ) ) ), 2) AS distance');
            $this->db->having('distance <= ', '5000');
            $this->db->order_by('distance', 'ASC');
        }
        if(isset($data['category_id']) && $data['category_id'] != ''){
            $this->db->join(TBL_STORE_CATEGORY, TBL_STORE_CATEGORY.'.store_id = '.TBL_STORE.'.store_id','Left');
            $this->db->where(TBL_STORE_CATEGORY.'.category_id', $data['category_id']);
        }

        $this->db->from(TBL_STORE);
        $this->db->where('status', 1);
        $this->db->limit($limit, $offset);
        
        $data = $this->db->get();
        return  $data->result_array();
        
    }

    public function countTotalRecord($data = array()){

        $limit = RECORD_LIMIT;
		$this->db->select(TBL_STORE.'.store_id');
        
        if(isset($data['keyword']) && $data['keyword'] != ''){
            $where = '('.TBL_STORE.'.name LIKE "%'.$data['keyword'].'%" OR '.TBL_STORE.'.additional_info LIKE "%'.$data['keyword'].'%" OR '.TBL_STORE.'.description LIKE "%'.$data['keyword'].'%")';
            $this->db->where($where);
        }

        if(isset($data['latitude']) && isset($data['latitude'])){
            $this->db->select('ROUND( ( 6373 * acos( cos( radians('.$data['latitude'].') ) * cos( radians( '.TBL_STORE.'.latitude ) ) * cos( radians( '.TBL_STORE.'.longitude ) - radians('.$data['longitude'].') ) + sin( radians('.$data['latitude'].') ) * sin( radians( '.TBL_STORE.'.latitude ) ) ) ), 2) AS distance');
            $this->db->having('distance <= ', '5000');
            $this->db->order_by('distance', 'ASC');
        }
        if(isset($data['category_id']) && $data['category_id'] != ''){
            $this->db->join(TBL_STORE_CATEGORY, TBL_STORE_CATEGORY.'.store_id = '.TBL_STORE.'.store_id','Left');
            $this->db->where(TBL_STORE_CATEGORY.'.category_id', $data['category_id']);
        }

        $this->db->from(TBL_STORE);
        $this->db->where('status', 1);
        $query = $this->db->get();
		$totalRecord = $query->num_rows();
		$total_pages = ceil($totalRecord / $limit);

		$results = array(
            'total_record' => $totalRecord,
			'page_no' => $data['page_no'],
			'total_pages' => $total_pages,
        );
        
        return $results;
    }

    public function searchLog($data){
        // dd($data);
        $logInsert = array(
            'category' => isset($data['category_id']) ? $data['category_id'] : '',
            'keyword' => isset($data['keyword']) ? $data['keyword'] : '',
            'location' => isset($data['location']) ? $data['location'] : '',
            'latitude' => isset($data['latitude']) ? $data['latitude'] : '',
            'longitude' => isset($data['longitude']) ? $data['longitude'] : '',
            'created_at' => date(DATE_FORMAT_DB),
            'updated_at' => date(DATE_FORMAT_DB),
        );
        
        $this->db->insert(TBL_SEARCH_LOG, $logInsert);
    }

    public function addStoreTime($data, $store_id, $store_timezone){
        // Remove Old time
        $this->db->where('store_id', $store_id);
        $this->db->delete(TBL_STORE_TIME);

        // Update Close store status
        $updateData = array(
            'close_message' => '',
            'is_closed' => 0,
            'store_timezone' => $store_timezone,
        );
        // dd($updateData);
        $this->db->where('store_id', $store_id);
        $this->db->update(TBL_STORE, $updateData);

        $this->db->insert_batch(TBL_STORE_TIME, $data); 
        return true;
    }

    public function getStoreTime($store_id){
        $this->db->select('*');
        $this->db->from(TBL_STORE_TIME);
        $this->db->where('store_id', $store_id);
        $data = $this->db->get();
        return  $data->result_array();
    }

    public function checkHoliday($data){
        $this->db->select('*');
        $this->db->from(TBL_STORE_HOLIDAY);
        $this->db->where('date', $data['date']);
        $this->db->where('store_id', $data['store_id']);
        $data = $this->db->get();
        return  $data->row_array();
    }

    public function addHoliday($data){
        $insert = array(
            'store_id' => $data['store_id'],
            'date' => $data['date'],
            'message' => $data['message']
        );
        // dd($insert);
        $this->db->insert(TBL_STORE_HOLIDAY, $insert);

        return $this->db->insert_id();
    }

    public function getStoreHoliday($store_id){
        $this->db->select('*');
        $this->db->from(TBL_STORE_HOLIDAY);
        // $this->db->where('date', $data['date']);
        $this->db->where('store_id', $store_id);
        $data = $this->db->get();
        return  $data->result_array();
    }

    public function removeHoliday($holiday_id){
        $this->db->where('store_holiday_id', $holiday_id);
        $this->db->delete(TBL_STORE_HOLIDAY);
        return true;
    }

    public function closeStore($data, $store_id){
        $insertData = array(
            'close_message' => $data['store_close_msg'],
            'is_closed' => $data['close_status']
        );
        // dd($insertData);
        $this->db->where('store_id', $store_id);
        $this->db->update(TBL_STORE, $insertData);
        // echo $this->db->last_query();
        return true;
    }

    public function getCurrentStoreStatus($store_id, $timeZone){
        if($timeZone != ''){
            date_default_timezone_set($timeZone);
        }else{
            $timeZone = date_default_timezone_get();
            date_default_timezone_set($timeZone);
        }
        
        $dayNum = date('N');
        $this->db->select('*');
        $this->db->from(TBL_STORE_TIME);
        $this->db->where('store_id', $store_id);
        $this->db->where('day', $dayNum);
        
        $query = $this->db->get();
        $storeTime = $query->row_array();
        // dd($storeTime);
        if($storeTime){
            $times = json_decode($storeTime['time'], true);
            // dd($times);
            $isOpen = false;
            $string = '';
            $now = date('H:i');
            // echo $now; die;
            if((date('H:i', strtotime($times[0]['to'])) <= $now && $now <= date('H:i', strtotime($times[0]['from']))) || (date('H:i', strtotime($times[1]['to'])) <= $now && $now <= date('H:i', strtotime($times[1]['from'])))){

                if((date('H:i', strtotime($times[0]['to'])) <= $now && $now <= date('H:i', strtotime($times[0]['from'])))){
                    $isOpen = true;
                    $slot = 1;
                    $string = '<strong class="text-success">Open</strong> | Closes '.date('h:i A', strtotime($times[0]['from']));
                }

                if((date('H:i', strtotime($times[1]['to'])) <= $now && $now <= date('H:i', strtotime($times[1]['from'])))){
                    $isOpen = true;
                    $slot = 2;
                    $string = '<strong class="text-success">Open</strong> | Closes '.date('h:i A', strtotime($times[1]['from']));
                }
            }else{
                if((date('H:i', strtotime($times[0]['from'])) <= $now && $now <= date('H:i', strtotime($times[1]['to']))) && $times[1]['to'] != ''){
                    $isOpen == false;
                    $slot = 1;
                    $string = '<strong class="text-danger">Closed</strong> | Opens '.date('h:i A', strtotime($times['1']['to']));
                }else{
                    $isOpen = false;
                    $slot = 2;
                    $getNextDayOpenTime = $this->getStoreNextDayOpenTime($store_id);
                    if($getNextDayOpenTime['to'] == ''){
                        $getNextDayOpenTime = $this->getFirstOpenDay($store_id);
                        $string = '<strong class="text-danger">Closed</strong> | Opens '.date('h:i A', strtotime($getNextDayOpenTime['to']));
                    }else{
                        $string = '<strong class="text-danger">Closed</strong> | Opens '.date('h:i A', strtotime($getNextDayOpenTime['to']));
                    }
                }
            }
        }else{
            $isOpen = false;
            $slot = 2;
            $getNextDayOpenTime = $this->getStoreNextDayOpenTime($store_id);
            if($getNextDayOpenTime['to'] == ''){
                $getNextDayOpenTime = $this->getFirstOpenDay($store_id);
                $string = '<strong class="text-danger">Closed</strong> | Opens '.date('h:i A', strtotime($getNextDayOpenTime['to']));
            }else{
                $string = '<strong class="text-danger">Closed</strong> | Opens '.date('h:i A', strtotime($getNextDayOpenTime['to']));
            }
        }
        $result = array(
            'store_time' => $storeTime,
            'isOpen' => $isOpen,
            'message' =>  $string,
            'slot' => $slot
        );  

        return $result;
        
    }

    public function getFirstOpenDay($store_id){
        $this->db->select('converted_time');
        $this->db->from(TBL_STORE_TIME);
        $this->db->where('store_id', $store_id);
        $this->db->where('slot_1 !=', '');
        $this->db->order_by('day', 'ASC');
        $query = $this->db->get();
        $result = $query->row_array();
        
        $converted_time = json_decode($result['converted_time'], true); 
        $startTime = $converted_time[0];

        return $startTime;
    }

    public function getStoreNextDayOpenTime($store_id){
        $dayNum = date('N', strtotime(' +1 day'));;
        $this->db->select('converted_time');
        $this->db->from(TBL_STORE_TIME);
        $this->db->where('store_id', $store_id);
        $this->db->where('day', $dayNum);
        
        $query = $this->db->get();
        $result = $query->row_array();
        // dd($result);
        $converted_time = json_decode($result['converted_time'], true); 
        $startTime = $converted_time[0];
        return $startTime;
    }

    public function checkForStoreHoliday($store_id){
        $this->db->select('*');
        $this->db->from(TBL_STORE_HOLIDAY);
        $this->db->where('store_id', $store_id);
        $this->db->where('date', date('Y-m-d'));
        
        $query = $this->db->get();
        $holiday = $query->row_array();

        if($holiday){
            $result = array(
                'is_holiday' => true,
                'message' => $holiday['message'],
            );
        }else{
            $result = array(
                'is_holiday' => false,
                'message' => '',
            );
        }

        return $result;
    }
}