<?php if(count($stores) == 0 ){ ?>
    <div class="highlight list-group-item no-results-item text-center">
        <p class="list-group-item-text">
            <strong><i class="fa fa-info-circle"></i> No results for this keyword.  We're sad.</strong>
        </p>
        <div>
            <br>Please try another location or keyword.<br><br>Click the 423First logo to begin again.
        </div>
        <br><a href="<?php echo base_url() ?>"><strong>423First HOME</strong></a>
    </div>
<?php }else{ ?>
    <div class="result-options" style="padding: 5px; display: block;">
        <div class="btn-group">
            <button type="button" class="btn btn-sm btn-default back-btn" <?php echo $total_store['page_no'] == 1 ? 'disabled' : '' ?> onclick="return findStore('<?php echo $total_store['page_no']-1 ?>')"><i class="fa fa-angle-double-left"></i></button>
            <button type="button" class="btn btn-sm btn-default forward-btn" <?php echo $total_store['page_no'] == $total_store['total_pages'] ? 'disabled' : '' ?> onclick="return findStore('<?php echo $total_store['page_no']+1 ?>')"><i class="fa fa-angle-double-right"></i> </button>

            <div class="pull-right text-muted btn-sm"><span class="total_items"><?php echo $total_store['total_record'] ?></span> results in <span class="distance"><?php echo $search_radius ?> mi</span></div>
        </div>
    </div>
    <?php foreach($stores as $store){ ?>
        
        <div class="list-group-item template-item">
            <div class="list-group-item-text">
                <?php if(isset($store['distance'])){ ?>
                    <div class="pull-right skip-popup"><small><?php echo $store['distance'] ?> mi</small></div>
                <?php } ?>
                <div class="btn-detail"><strong><?php echo $store['name'] ?></strong></div>
                <?php if(isset($store['image']) && $store['image'] != ''){ ?>
                    <div class="image">
                        <img src="<?php echo $store['image'] ?>" class="image" height="25" alt="<?php echo $store['name'] ?>">
                    </div>
                <?php } ?>
                <div>   
                    <div class="clearfix">
                        <div class="pull-right skip-popup"><br><a href="javascript:void(0);" onClick="getStoreDetail('<?php echo $store['store_id'] ?>')" class="btn btn-default btn-detail"><i class="fa fa-chevron-right"> <font face="arial"><b>Click to View</b></font></i> </a></div>
                        <div class="pull-left skip-popup">
                            <?php if($store['website'] != ''){ ?>
                                <div class="website"><a href="https://<?php echo $store['website'] ?>" target="_blank" class="website">CLICK FOR WEBSITE</a></div>
                            <?php } ?>
                            <div><small><?php echo $store['address'] ?></small></div>
                            <div>
                                <small><?php echo $store['city'] ?> <?php echo $store['state'] ?> <?php echo $store['postal_code'] ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="social-links">
                        <?php if($store['twitter'] != ''){ ?>
                            <a href="<?php echo $store['twitter'] ?>" title="Twitter" target="_blank" class="twitter"><i class="fa fa-twitter-square fa-lg"></i></a>
                        <?php } ?>
                        <?php if($store['youtube'] != ''){ ?>
                            <a href="<?php echo $store['youtube'] ?>" title="YouTube" target="_blank" class="youtube"><i class="fa fa-youtube-square fa-lg"></i></a>
                        <?php } ?>
                        <?php if($store['linkedin'] != ''){ ?>
                            <a href="<?php echo $store['linkedin'] ?>" title="LinkedIn" target="_blank" class="linkedin"><i class="fa fa-linkedin-square fa-lg"></i></a>
                        <?php } ?>  
                        <?php if($store['pinterest'] != ''){ ?>
                            <a href="<?php echo $store['pinterest'] ?>" title="Pinterest" target="_blank" class="pinterest"><i class="fa fa-pinterest-square fa-lg"></i></a>
                        <?php } ?>
                        <?php if($store['pinterest'] != ''){ ?>
                            <a href="<?php echo $store['pinterest'] ?>" title="Instagram" target="_blank" class="instagram"><i class="fa fa-instagram fa-lg"></i></a>
                        <?php } ?>
                        <?php if($store['facebook'] != ''){ ?>
                            <a href="<?php echo $store['facebook'] ?>" title="Facebook" target="_blank" class="facebook"><i class="fa fa-facebook-square fa-lg"></i></a>
                        <?php } ?>
                    </div>
                    
                    <div style="margin-top:5px; font-size:90%;">
                        <a class="btn-detail" onClick="getStoreDetail('<?php echo $store['store_id'] ?>')"><i class="fa fa-map-marker"></i> Directions &amp; Hours</a>
                        <!-- <br> -->
                        <?php if(count($store['all_time']) > 0){ ?>
                            <?php if($store['is_closed'] == '1'){ ?>
                                <span style="margin-top:10px; margin-bottom:10px; display: block"><strong class="text-danger">Closed</strong> | <?php echo $store['close_message'] != '' ? $store['close_message'] : 'Temporarily closed' ?></span>
                            <?php }else if($store['holiday']['is_holiday'] == true){ ?>
                                <span style="margin-top:10px; margin-bottom:10px; display: block"><strong class="text-danger">Closed</strong> | <?php echo $store['holiday']['message'] != '' ? $store['holiday']['message'] : 'Holiday closed' ?></span>
                            <?php }else{ ?>
                                <span style="margin-top:10px; margin-bottom:10px; display: block"><?php echo $store['timming']['message'] ?></span>
                            <?php } ?>
                        <?php } ?>

                        <?php if($store['phone'] != ''){ ?>
                            <a href="tel:<?php echo $store['phone'] ?>" class="phone"><i class="fa fa-phone-square"></i> <?php echo $store['phone'] ?></a>
                        <?php } ?>

                        <?php if($store['fax'] != ''){ ?>
                            <a href="tel:<?php echo $store['fax'] ?>" class="fax"><i class="fa fa-print"></i> <?php echo $store['fax'] ?></a>
                        <?php } ?>  

                        <?php if($store['email'] != ''){ ?>
                            <a href="mailto:<?php echo $store['email'] ?>" class="email"><i class="fa fa-envelope"></i> <?php echo $store['email'] ?></a>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
            $locations[] = array(
                'store_name' => $store['name'],
                'latitude' => $store['latitude'],
                'longitude' => $store['longitude']
            );
        ?>
        
    <?php } ?>

    <script>
        $(document).ready(function(){
            <?php // get All filted stoer location for displaying on map  ?>
            var locations = <?php echo json_encode($locations); ?>;

            <?php // create map  ?>
            document.getElementById('storeMap').innerHTML = '<div id="map1" class="map_area"></div>';
            var map = L.map('map1').setView([locations[0].latitude, locations[0].longitude], 13);
            L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
                attribution: '&copy; <a href="https://osm.org/copyright">OpenStreetMap</a> contributors'
            }).addTo(map);
            
            $.each(locations, function( index, value ) {
                marker = new L.marker([value.latitude,value.longitude]).bindPopup(value.store_name).addTo(map);
            });
        });
        
    </script>
<?php } ?>