<!-- detail template -->
<div class="list-group loc-store-detail-template">
    <div class="highlight list-group-item">
        <div class="pull-right btn-group">
            <!-- <a href="#" class=" btn btn-default btn-sm link-btn"><i class="fa fa-bookmark"></i></a> -->
            <button class="btn btn-default btn-sm close-btn"><i class="fa fa-times"></i></button>
        </div>
        <h5>423First Verified Partner</h5>
    </div>
    <div class="list-group-item template-item">
        <div class="list-group-item-text">
            <h4><?php echo $store['name'] ?></h4>
            <?php if(isset($store['image']) && $store['image'] != ''){ ?>
                <img src="<?php echo $store['image'] ?>" alt="<?php echo $store['name'] ?>" class="image" height="50">
            <?php } ?>
            <div>
                <div>
                    <small><?php echo $store['address'] ?></small>
                </div>
                <div>
                    <small><?php echo $store['city'] ?> <?php echo $store['state'] ?> <?php echo $store['postal_code'] ?></small>
                </div>
                <div class="social-links">
                    <?php if($store['twitter'] != ''){ ?>
                        <a href="<?php echo $store['twitter'] ?>" title="Twitter" target="_blank" class="twitter"><i class="fa fa-twitter-square fa-lg"></i></a>
                    <?php } ?>
                    <?php if($store['youtube'] != ''){ ?>
                        <a href="<?php echo $store['youtube'] ?>" title="YouTube" target="_blank" class="youtube"><i class="fa fa-youtube-square fa-lg"></i></a>
                    <?php } ?>
                    <?php if($store['linkedin'] != ''){ ?>
                        <a href="<?php echo $store['linkedin'] ?>" title="LinkedIn" target="_blank" class="linkedin"><i class="fa fa-linkedin-square fa-lg"></i></a>
                    <?php } ?>  
                    <?php if($store['pinterest'] != ''){ ?>
                        <a href="<?php echo $store['pinterest'] ?>" title="Pinterest" target="_blank" class="pinterest"><i class="fa fa-pinterest-square fa-lg"></i></a>
                    <?php } ?>
                    <?php if($store['pinterest'] != ''){ ?>
                        <a href="<?php echo $store['pinterest'] ?>" title="Instagram" target="_blank" class="instagram"><i class="fa fa-instagram fa-lg"></i></a>
                    <?php } ?>
                    <?php if($store['facebook'] != ''){ ?>
                        <a href="<?php echo $store['facebook'] ?>" title="Facebook" target="_blank" class="facebook"><i class="fa fa-facebook-square fa-lg"></i></a>
                    <?php } ?>
                </div>
                <div style="margin-top:5px; font-size:90%;">
                    <?php if($store['website'] != ''){ ?>
                        <div class="website"><a href="https://<?php echo $store['website'] ?>" target="_blank" class="website"><i class="fa fa-globe"></i> <?php echo $store['website'] ?></a></div>
                    <?php } ?>
                    <div>
                        <?php if($store['phone'] != ''){ ?>   
                            <a href="tel:<?php echo $store['phone'] ?>" class="phone"><i class="fa fa-phone-square"></i> <?php echo $store['phone'] ?></a>
                        <?php } ?>
                        <?php if($store['fax'] != ''){ ?>
                            <a href="tel:<?php echo $store['fax'] ?>" class="fax"><i class="fa fa-print"></i> <?php echo $store['fax'] ?></a>
                        <?php } ?>
                        <?php if($store['email'] != ''){ ?>
                            <a href="mailto:<?php echo $store['email'] ?>" class="email"><i class="fa fa-envelope"></i> <?php echo $store['email'] ?></a>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if(count($store['all_time']) > 0){ ?>
    <div class="list-group-item template-item" style="cursor: pointer">
        <div class="list-group-item-text" style="min-height: 50px;">
            <section class="categories" style="margin-bottom: 5px;">
                <div style="font-weight: bold;">423First Hours</div>
                <div class="dropdown">
                    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                        <?php if($store['is_closed'] == '1'){ ?>
                            <strong class="text-danger">Closed</strong> | <?php echo $store['close_message'] != '' ? $store['close_message'] : 'Temporarily closed' ?>
                        <?php }else if($store['holiday']['is_holiday'] == true){ ?>
                            <strong class="text-danger">Closed</strong> | <?php echo $store['holiday']['message'] != '' ? $store['holiday']['message'] : 'Holiday closed' ?>
                        <?php }else{ ?>
                            <?php echo $store['today_time']['message'] ?> 
                        <?php } ?>
                        <i class="fa fa-caret-down"></i>
                    </button>
                    <ul class="dropdown-menu timming" role="menu">
                        <?php if($store['is_closed'] == '1'){ ?>
                            <li class="today">
                                Time not available
                            </li>
                        <?php }else{ ?>
                            <?php foreach ($store['all_time'] as $key => $all_time) { ?>
                                <li class="<?php echo $all_time['day'] == date('N') ? "today" : '' ?>">
                                    <span class="day_name"> <?php echo date('l', strtotime("Sunday +".$all_time['day']." days")) ?></span>
                                    <span class="day_time">
                                        <?php if($all_time['day'] == date('N')){ ?>
                                            <?php if($store['holiday']['is_holiday'] == true){ ?>
                                                <strong class="text-danger">Closed</strong> | <?php echo $store['holiday']['message'] != '' ? $store['holiday']['message'] : 'Holiday closed' ?>
                                            <?php } ?>
                                        <?php } ?> 
                                            <?php $times = json_decode($all_time['time'], true); ?>
                                            <?php foreach ($times as $key => $time) { ?>
                                                <?php if($time['to'] != '' && $time['from'] != ''){ ?>
                                                    <div><?php echo date('h:i A', strtotime($time['to'])).' - '.date('h:i A', strtotime($time['from'])) ?></div>
                                                <?php } ?>
                                            <?php } ?>
                                        <?php //} ?>
                                    </span>
                                </li>
                            <?php } ?>
                        <?php } ?>
                    </ul>
                </div>
            </section>
        </div>
    </div>
    <?php } ?>
    <div class="list-group-item template-item" style="cursor: pointer">
        <div class="list-group-item-text">
            <div style="font-weight: bold;">Directions</div>
            <div>
                <div style="margin-top:5px;" class="btn-group">
                    <div class="dropdown">
                        <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown"><i class="fa fa-compass"></i> Get Directions <i class="fa fa-caret-down"></i></button>
                        <ul class="dropdown-menu direction-links" role="menu">
                            <li><a href="https://www.google.com/maps/dir/?api=1&destination=<?php echo $store['latitude'] ?>,<?php echo $store['longitude'] ?>" id="google_dir" target="_blank"><i class="fa fa-external-link"></i> Google Maps Directions</a></li>
                            <li><a href="https://www.bing.com/maps?rtp=~pos.<?php echo $store['latitude'] ?>_<?php echo $store['longitude'] ?>" target="_blank"><i class="fa fa-external-link"></i> Bing Maps Directions</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if($store['additional_info'] != ''){ ?>
        <div class="list-group-item template-item" style="">
            <div class="list-group-item-text" style="min-height: 50px;">
                <div style="font-weight: bold;">Welcome</div>
                <div>
                    <div>
                        <small><?php echo $store['additional_info'] ?></small>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
    <?php if($store['description'] != ''){ ?>
        <div class="list-group-item template-item" style="cursor: pointer">
            <div class="list-group-item-text" style="min-height: 50px;">
                <section class="categories" style="margin-bottom: 5px;">
                    <div style="font-weight: bold;">423First Location Info</div>
                    <div>
                        <div>
                        <small><?php echo $store['description'] ?></small>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    <?php } ?>
    <?php if($store['categories']){ ?>
        <div class="list-group-item template-item" style="">
            <div class="list-group-item-text" style="min-height: 50px;">
                <div style="font-weight: bold;">423First Categories</div>
                <div>
                    <?php foreach($store['categories'] as $category){ ?>
                    <div>
                        <small><i class="<?php echo $category['icon'] ?>"></i> <?php echo $category['title'] ?></small>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    <?php } ?>
    
</div>
<?php
    $locations = array(
        'store_name' => $store['name'],
        'latitude' => $store['latitude'],
        'longitude' => $store['longitude']
    );
?>
<script>
    $(document).ready(function(){
        $('.close-btn').on('click', function(){
            $('.store_detail').html('');
            $('.loc-result-set').css('opacity', 1);
        });

        $('.dropdown-toggle').on('click', function(){
            if($(this).parent('.dropdown').hasClass('open')){
                $(this).parent('.dropdown').removeClass('open');
            }else{
                $(this).parent('.dropdown').addClass('open');
            }
        });
    });
</script>
<script>
    
    var locations = <?php echo json_encode($locations); ?>

    <?php // display single store on map with popup  ?>
    // document.getElementById('storeMap').innerHTML = '';
    document.getElementById('storeMap').innerHTML = '<div id="map1" class="map_area"></div>';
    var map = L.map('map1').setView([locations.latitude, locations.longitude], 13);
    L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
        attribution: '&copy; <a href="https://osm.org/copyright">OpenStreetMap</a> contributors'
    }).addTo(map);
    var popupHtml = "<h4><?php echo $store['name'] ?></h4><div><small><?php echo $store['address'] ?></small></div><div><small><?php echo $store['city'] ?> <?php echo $store['state'] ?> <?php echo $store['postal_code'] ?></small></div>";

    popupHtml += '<div>';
        <?php if($store['website'] != ''){ ?>
            popupHtml += '<div class="website"><a href="https://<?php echo $store['website'] ?>" target="_blank" class="website"><i class="fa fa-globe"></i> <?php echo $store['website'] ?></a></div>';
        <?php } ?>
        popupHtml += '<div>';
            <?php if($store['phone'] != ''){ ?>   
                popupHtml += '<a href="tel:<?php echo $store['phone'] ?>" class="phone"><i class="fa fa-phone-square"></i> <?php echo $store['phone'] ?></a>';
            <?php } ?>
            <?php if($store['fax'] != ''){ ?>
                popupHtml += '<a href="tel:<?php echo $store['fax'] ?>" class="fax"><i class="fa fa-print"></i> <?php echo $store['fax'] ?></a>';
            <?php } ?>
            <?php if($store['email'] != ''){ ?>
                popupHtml += '<a href="mailto:<?php echo $store['email'] ?>" class="email"><i class="fa fa-envelope"></i> <?php echo $store['email'] ?></a>';
            <?php } ?>
        popupHtml += '</div>';
    popupHtml += '</div>';
    var marker = L.marker([locations.latitude, locations.longitude]).bindPopup(popupHtml).addTo(map).openPopup();
</script>