<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Category extends CI_Controller {

	function __construct(){

		parent::__construct();

		if(!$this->session->userdata(APP_NAME.'_logged_in'))

            redirect('/admin', 'refresh');

		if($this->session->userdata(APP_NAME.'_logged_in')['permission'] != 1){
			$this->session->set_flashdata('error','You dont have permission for this.');
			redirect('/admin/store', 'refresh');
		}

		$this->adminInfo = $this->session->userdata(APP_NAME.'_logged_in');

		$this->load->model('Model_category');

    }

    public function index(){

		$meta['page_title'] = $data['page_title'] = 'Category Management';

		$data['ajax_data_url'] = base_url('admin/category/ajaxList');

		$this->load->view('admin/common/header', $meta);

		$this->load->view('admin/category/list', $data);

		$this->load->view('admin/common/footer');

	}

	public function ajaxList(){        

        $start = $this->input->get('start');

        $no_of_rec = $this->input->get('length');

        $searchKeyword = $this->input->get('sSearch');

        $data['records'] = $this->Model_category->getListRecord($start,$no_of_rec,$this->input->get());

        $total_rec = $this->Model_category->countAllRecord($this->input->get());

        $data['iDisplayStart'] = $start;

		

		$r_data = $this->load->view('admin/category/ajax/list', $data, true);

        // dd($r_data);

        if($total_rec != '') {

            $t_data['a_data']['aaData'] = json_decode($r_data, true);

        } else {

            $t_data['a_data']['aaData'] = array();

        }

        $t_data['a_data']['sEcho'] = $this->input->get('sEcho');

        $t_data['a_data']['iTotalRecords'] = $total_rec;

        $t_data['a_data']['iTotalDisplayRecords'] = $total_rec;

        echo json_encode($t_data['a_data']);

    }

    public function create(){

		$meta['page_title'] = $data['page_title'] = 'Add Category';

        

        $data['is_back'] = true;

		if($this->session->flashdata('validation')){

			$data['validation'] = $this->session->flashdata('validation');

		}

		$data['validation_url'] = base_url('admin/category/validateCategory');

		

		$this->load->view('admin/common/header', $meta);

		$this->load->view('admin/category/form', $data);

		$this->load->view('admin/common/footer');

	}

	

	public function validateCategory($isJson = true){

		$post = $this->input->post();

		

        $this->form_validation->set_rules('title', 'Title', 'required');

        $this->form_validation->set_rules('icon', 'Icon', 'required');

		$this->form_validation->set_rules('status', 'Status', 'required');

		$this->form_validation->set_rules('type', 'Type', 'required');

        if ($this->form_validation->run() == true){

            $result = array();

        }else{

			$result['errors'] = $this->form_validation->error_array();

		}

		if($isJson == true){

			echo json_encode($result);

			die;

		}else{

			return $result;

		}

	}

	public function save(){

		$post = $this->input->post();

		

		$validateRequest = $this->validateCategory(false);

		if(count($validateRequest) > 0){

			$this->session->set_flashdata('validation', $validateRequest['errors']);

			$this->session->set_flashdata('error','Please check the form carefully for errors!.');

			redirect('admin/category/create','refresh');

		}else{

			if(isset($post['image']) && $post['image'] != ''){

				$post['image'] = base64ToImage($post['image'], 'category/');

			}

			if($post['category_id'] != ''){

				$this->Model_category->update($post);

				$this->session->set_flashdata('success','Category successfully Updated!.');

			}else{

				$this->Model_category->insert($post);

				$this->session->set_flashdata('success','Category successfully created!.');

			}

			redirect('admin/category','refresh');

		}

	}

	public function searchCategoryByName(){

		$json = [];

        

        $search = !empty($this->input->get("q")) ? $this->input->get("q") : '';

        $getData = $this->Model_category->searchCategoryByName($search);

		echo json_encode($getData);

		die;

	}

	public function edit($category_id){

		$meta['page_title'] = $data['page_title'] = 'Update Category';

        $data['is_back'] = true;

		$data['validation_url'] = base_url('admin/category/validateCategory');

		if($this->session->flashdata('validation')){

			$data['validation'] = $this->session->flashdata('validation');

		}

		$promoterProfile = $this->Model_category->getCategoryById($category_id);

		$data['category'] = $promoterProfile;

		

		$this->load->view('admin/common/header', $meta);

		$this->load->view('admin/category/form', $data);

		$this->load->view('admin/common/footer');

    }

    

    public function remove($category_id){

        $this->Model_category->remove($category_id);

        $this->session->set_flashdata('success','Category successfully Removed!.');

        redirect('admin/category','refresh');

    }

}