<!-- Load Leaflet from CDN -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.6.0/dist/leaflet.css"/>
<script src="https://unpkg.com/leaflet@1.6.0/dist/leaflet.js"></script>
<script src="https://leaflet.github.io/Leaflet.heat/dist/leaflet-heat.js"></script>
<!-- <script src="https://leaflet.github.io/Leaflet.markercluster/example/realworld.10000.js"></script> -->

<!-- Start Content-->
<div class="container-fluid">
    
    <!-- start page title -->
            <?php $this->load->view('admin/common/breadcrumb', true); ?>
    <!-- end page title --> 
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12" id="heat-map-container">
                            <table class="table">
                                <thead>
                                <tr>
                                    <th style="text-align: left;">
                                        <h4>Search History Heat Map</h4>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr>
                                    <td style="padding:0px;">
                                        <div id="heatmap" style="height:400px; background-color: #ddd;">
                                            <div style="text-align: center; font-size:20px; padding: 100px 0px;">
                                            <i class="fa fa-spin fa-spinner"></i></div>
                                        </div>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>  

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12" id="category-total">
                            <table class="table table-striped table-hover table-sm table-condensed">
                                <thead>
                                    <tr>
                                        <th colspan="4" style="text-align: left;">
                                            <h4>Category Search Totals</h4>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th style="text-align: left;">Category</th>
                                        <th>Search Count</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($category_states as $states): ?>
                                    <tr>
                                        <td><?php echo empty($states['title']) ? "No Category" : $states['title']; ?></td>
                                        <td><?php echo $states['count']; ?></td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> 
              
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-6">
                            <h4 class="header-title mb-4">
                                Filter Search History
                            </h4>
                        </div>
                        <div class="col-6">
                            <button class="btn btn-primary float-right waves-effect waves-light" id="clear_filter">Clear Filters</button>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-12 col-sm-3 col-md-3 col-lg-3">
                            <label for="category_id">By Category Name</label>
                            <select class="form-control select2 filter" id="category_id"></select>
                        </div>                        
                        <div class="col-12 col-sm-3 col-md-3 col-lg-3">
                            <label for="keyword">By Keyword</label>
                            <input type="text" class="form-control filter"  id="keyword" autocomplete="off">
                        </div>
                        <div class="col-12 col-sm-3 col-md-3 col-lg-3">
                            <label for="location">By Location</label>
                            <input type="text" class="form-control filter"  id="location" autocomplete="off">
                        </div>
                        <div class="col-12 col-sm-3 col-md-3 col-lg-3">
                            <label for="category">By Create Date</label>
                            <div class="input-group">
                                <input type="text" class="form-control filter datepicker"  id="date_filter" autocomplete="off">
                                <div class="input-group-append">
                                    <span class="input-group-text"><i class="ti-calendar"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-6">
                            <h4 class="header-title mb-4">
                                Browse Search History
                            </h4>
                        </div>
                    </div>
                    <table id="list-table" class="table dt-responsive nowrap">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Category</th>
                                <th>Keyword</th>
                                <th>Location</th>
                                <th>Date/Time</th>
                            </tr>
                        </thead>
                    </table>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->
</div>

<script type="text/javascript">
    
    jQuery('#category_id').select2({
        placeholder: '--- Select Category Name ---',
        ajax: {
          url: '<?php echo base_url('admin/category/searchCategoryByName'); ?>',
          dataType: 'json',
          delay: 250,
          processResults: function (data) {
            return {
              results: data
            };
          },
          cache: true
        }
    });

    $(document).on("change", ".filter", function(event) {  
        var ajaxdata = { 
            "category_id": $('#category_id').val(),
            "keyword": $('#keyword').val(),
            "location": $('#location').val(),
            "create_date": $('#date_filter').val()
        };
        displayDataTableReport("#list-table", '<?php echo $ajax_data_url; ?>', ajaxdata);
    });
    jQuery(document).ready(function(e) {
        var ajaxdata = { 
            "category_id": $('#category_id').val(),
            "keyword": $('#keyword').val(),
            "location": $('#location').val(),
            "create_date": $('#date_filter').val()
        };

        displayDataTableReport("#list-table", '<?php echo $ajax_data_url; ?>', ajaxdata);
        $('.datepicker').datepicker({
            autoclose: true,
            todayHighlight: true,
            format: 'dd/mm/yyyy'
        });

        $('#clear_filter').click(function(){
            location.reload(true);
        });
    });

    var lat = "<?php echo isset($default_lat) ? $default_lat : '' ?>";
    var lng = "<?php echo isset($default_lng) ? $default_lng : '' ?>";
    var zoom = "<?php echo isset($default_zoom) ? $default_zoom : '' ?>";

    var addressPoints = JSON.parse('<?php echo json_encode($heat_map) ?>');
    var map = L.map('heatmap').setView([lat, lng], 2);

    var tiles = L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
        attribution: '&copy; <a href="https://osm.org/copyright">OpenStreetMap</a> contributors',
    }).addTo(map);

    addressPoints = addressPoints.map(function (p) { 
        // console.log(p);
        return [ p[0], p[1]]; 
    });

    var heat = L.heatLayer(addressPoints).addTo(map);
</script>
