<?php
class Notification extends  CI_Controller {
	function __construct(){
	    parent::__construct();
	    if(!$this->session->userdata(APP_NAME.'_logged_in'))
	        redirect('/admin/', 'refresh');
	        
		$this->load->model('Model_messages');
		$this->load->model('Model_category');
	    $this->load->model('Model_notification', 'notification');
	}
	public function send_notification($notification_id = 0){
		  
	    $logged_in = $this->session->userdata('logged_in');
	    //  Header Information
	    $meta['page_title'] = $data['page_title'] = 'Send Notification';
		// Page Information
		$data['topics'] = $this->Model_category->getCategory($level = 0);
	    $data['notification_save_type'] = 'new';
	    $data['notification_id'] = $notification_id;
		$data['submit_url'] = base_url('admin/notification/save');
	    
	    // Page Data
	    $this->load->view('admin/common/header', $meta);
	    $this->load->view('admin/notification/send_notification', $data);
	    $this->load->view('admin/common/footer');
	}
  	public function save(){
	    $logged_in = $this->session->userdata('logged_in');
		$data = $_POST;
		if($data['users']=="0"){
			$user_ids = 0;
			$ids = 0;
		}else{
			$user_ids = $data['user_ids'];
			$ids = implode(',', $user_ids);
		}
		$image = '';
		if($data['image'] != ''){
			$uploadPath = UPLOAD_PATH.'/notification/';
			if (!is_dir($uploadPath)) {
				mkdir($uploadPath, 0777, TRUE);
			}
			$image_parts = str_replace('data:image/png;base64,', '', $this->input->post('image')); 
			$image_base64 = base64_decode($image_parts);
			// create file name
			$fileName = uniqid(). '.png';
			$file = $uploadPath . $fileName;
			// store path in DB
			$image = $fileName;
			// echo $file; die;
			file_put_contents($file, $image_base64);
		}
		
		if($data['notification_type'] == '2'){
			// TBL_SCHEDULE_NOTIFICATION
			$insertNotificatoin = array(
				'user_ids' => $ids,
				'timming' => $data['schedule_time'],
				'subject' => $data['subject'],
				'message' => $data['message'],
				'image' => $image,
				'status' => 0,
			);
			
			$insertNotification = $this->Model_messages->scheduleNotification($insertNotificatoin);
			if($insertNotification){
				$this->session->set_flashdata('success','Notification Scheduled Succesfully.');
			}else{
				$this->session->set_flashdata('error','Scheduleing Failed.');
			}
			redirect('admin/notification/notification_list','refresh');
		}else{
			$notificatoindata['push'] = array(
				'subject' => $data['subject'],
				'message' => $data['message'],
				'image' => $image != "" ? UPLOAD_URL.'/notification/'.$image : '',
				'action' => '',
				'action_id' => ''
			);
			
			$sendNotification = $this->Model_messages->NotifyCustomer($user_ids, $notificatoindata, ['push'], true);
			// dd($sendNotification);
			if($sendNotification){
				$this->session->set_flashdata('success','Notification Send Succesfully.');
			}else{
				$this->session->set_flashdata('error','Sending Failed.');
			}
			redirect('admin/notification/notification_list','refresh');
		}
		
	    
	}
	  
  	public function notification_list(){
	    $logged_in = $this->session->userdata('logged_in');
	    //  Header Information
	    $meta['page_title'] = $data['page_title'] = 'Notifications';
	    $data['ajax_data_url'] = base_url('admin/notification/ajaxNotificationList');
	    $this->load->view('admin/common/header', $meta);
	    $this->load->view('admin/notification/list', $data);
	    $this->load->view('admin/common/footer');
	}
	  
  	public function ajaxNotificationList(){
	    $start = $_GET['iDisplayStart'];
	    $no_of_rec = $_GET['iDisplayLength'];
	    $searchKeyword = $_GET['sSearch'];
	    $data['records'] = $this->notification->getDTableNotifiaction($start,$no_of_rec,$_GET);
	    $total_rec = $this->notification->count_all($_GET);
	    $data['iDisplayStart'] = $start;
	    $r_data = $this->load->view('admin/notification/ajax/list', $data, true);
	    if($total_rec != '') {
	      $t_data['a_data']['aaData'] = json_decode($r_data, true);
	    } else {
	      $t_data['a_data']['aaData'] = array();
	    }
	    $t_data['a_data']['sEcho'] = $_GET['sEcho'];
	    $t_data['a_data']['iTotalRecords'] = $total_rec;
	    $t_data['a_data']['iTotalDisplayRecords'] = $total_rec;
	    echo json_encode($t_data['a_data']);
	}
	  
	public function schedule(){
		$logged_in = $this->session->userdata('logged_in');
		//  Header Information
		$meta['page_title'] = $data['page_title'] = 'Schedule Notifications';
		$data['ajax_data_url'] = base_url('admin/notification/ajaxScheduleNotificationList');
		$this->load->view('admin/common/header', $meta);
		$this->load->view('admin/notification/list_schedule', $data);
		$this->load->view('admin/common/footer');
	}
	public function ajaxScheduleNotificationList(){
	    $start = $_GET['iDisplayStart'];
	    $no_of_rec = $_GET['iDisplayLength'];
	    $searchKeyword = $_GET['sSearch'];
	    $data['records'] = $this->notification->getDTableScheduleNotifiaction($start,$no_of_rec,$_GET);
	    $total_rec = $this->notification->count_allSchedule($_GET);
	    $data['iDisplayStart'] = $start;
	    $r_data = $this->load->view('admin/notification/ajax/list_schedule', $data, true);
	    if($total_rec != '') {
	      $t_data['a_data']['aaData'] = json_decode($r_data, true);
	    } else {
	      $t_data['a_data']['aaData'] = array();
	    }
	    $t_data['a_data']['sEcho'] = $_GET['sEcho'];
	    $t_data['a_data']['iTotalRecords'] = $total_rec;
	    $t_data['a_data']['iTotalDisplayRecords'] = $total_rec;
	    echo json_encode($t_data['a_data']);
	}
	public function remove($notificationId){
		$removeNotification = $this->notification->removeScheduleNotification($notificationId);
				
		if($removeNotification){
			$this->session->set_flashdata('success','Notification Succesfully Removed.');
		}else{
			$this->session->set_flashdata('error','Error! Try Again');
		}
		redirect('admin/notification/schedule','refresh');		
	}
	  
}