<?php if(count($stores) == 0 ){ ?>
    <div class="highlight list-group-item no-results-item text-center">
        <p class="list-group-item-text">
            <strong><i class="fa fa-info-circle"></i> No results for this keyword.  We're sad.</strong>
        </p>
        <div>
            <br>Please try another location or keyword.<br><br>Click the 423 logo to begin again.
        </div>
        <br><a href="<?php echo base_url() ?>"><strong>Hixson Pike HOME</strong></a>
    </div>
<?php }else{ ?>
    <div class="result-options" style="padding: 5px; display: block;">
        <div class="btn-group">
            <button type="button" class="btn btn-sm btn-default back-btn" <?php echo $total_store['page_no'] == 1 ? 'disabled' : '' ?> onclick="return findStore('<?php echo $total_store['page_no']-1 ?>')"><i class="far fa-caret-square-left"></i></button>
            <button type="button" class="btn btn-sm btn-default forward-btn" <?php echo $total_store['page_no'] == $total_store['total_pages'] ? 'disabled' : '' ?> onclick="return findStore('<?php echo $total_store['page_no']+1 ?>')"><i class="far fa-caret-square-right"></i> </button>

            <div class="pull-right text-muted btn-sm"><span class="total_items"><?php echo $total_store['total_record'] ?></span> results in <span class="distance"><?php echo $search_radius ?>  mi</span></div>
        </div>
    </div>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/fancyapps/fancybox@3.5.7/dist/jquery.fancybox.min.css" />
    <script src="https://cdn.jsdelivr.net/gh/fancyapps/fancybox@3.5.7/dist/jquery.fancybox.min.js"></script>

    <div class="store_list_area">
        <?php foreach($stores as $store){ ?>
            <div class="store_area">
                <div class="lbg_evento_padding clearfix">
                    <?php if(isset($store['distance'])){ ?>
                        <div class="lbg-event-fist-date"><?php echo $store['distance'] ?></div>
                        <div class="lbg-event-second-date">&nbsp;mi</div>
                    <?php } ?>
                    <div class="lbg-event-title-and-details-area">
                        <div class="lbg-event-title"><?php echo $store['name'] ?></div>
                        <div class="lbg-event-initial-details">
                            <?php if($store['is_closed'] == '1'){ ?>
                                <span class="store_time_span"><strong class="text-danger">Closed</strong> | <?php echo $store['close_message'] != '' ? $store['close_message'] : 'Temporarily closed' ?></span>
                            <?php }else if($store['holiday']['is_holiday'] == true){ ?>
                                <span class="store_time_span"><strong class="text-danger">Closed</strong> | <?php echo $store['holiday']['message'] != '' ? $store['holiday']['message'] : 'Holiday closed' ?></span>
                            <?php }else{ ?>
                                <span class="store_time_span"><?php echo $store['timming']['message'] ?></span>
                            <?php } ?>
                            <?php echo $store['address'] ?> <?php echo $store['city'] ?> <?php echo $store['state'] ?> <?php echo $store['postal_code'] ?>
                        </div>
                        <div class="lbg_evento_dresscode">
                            <?php if($store['phone'] != ''){ ?>
                                <a href="tel:<?php echo $store['phone'] ?>" class="phone link"><i class="fa fa-phone-square"></i> <?php echo $store['phone'] ?></a>
                            <?php } ?>

                            <?php if($store['fax'] != ''){ ?>
                                <a href="tel:<?php echo $store['fax'] ?>" class="fax link"><i class="fa fa-print"></i> <?php echo $store['fax'] ?></a>
                            <?php } ?>  

                            <?php if($store['email'] != ''){ ?>
                                <a href="mailto:<?php echo $store['email'] ?>" class="email link"><i class="fa fa-envelope"></i> <?php echo $store['email'] ?></a>
                            <?php } ?>
                        </div>
                    </div>
                </div>

                <div class="event_booknow_text">
                    <a href="javascript:void(0);">See Inside</a>
                </div>

                
                
                <div class="lbg_event_all_details">
                    <div class="lbg_socials">
                        <ul>
                        <?php if($store['twitter'] != ''){ ?>
                            <li><a href="<?php echo $store['twitter'] ?>" title="Twitter" target="_blank" class="fab fa-twitter lbg_evento_twitter" aria-hidden="true"></a></li>
                        <?php } ?>
                        <?php if($store['youtube'] != ''){ ?>
                            <li><a href="<?php echo $store['youtube'] ?>" title="YouTube" target="_blank" class="fab fa-youtube" aria-hidden="true"></a></li>
                        <?php } ?>
                        <?php if($store['linkedin'] != ''){ ?>
                            <li><a href="<?php echo $store['linkedin'] ?>" title="LinkedIn" target="_blank" class="fab fa-linkedin-in" aria-hidden="true"></a></li>
                        <?php } ?>  
                        <?php if($store['pinterest'] != ''){ ?>
                            <li><a href="<?php echo $store['pinterest'] ?>" title="LinkedIn" target="_blank" class="fab fa-pinterest-p lbg_evento_pinterest" aria-hidden="true"></a></li>
                        <?php } ?>
                        <?php if($store['facebook'] != ''){ ?>
                            <li><a href="<?php echo $store['facebook'] ?>" title="Facebook" target="_blank" class="fab fa-facebook-f lbg_evento_fb" aria-hidden="true"></a></li>
                        <?php } ?>
                        </ul>
                   </div>
                    <?php if($store['description'] != ''){ ?>
                        <div class="lbg_details_title">
                            <span class="lbg_arrow far fa-arrow-alt-circle-right" aria-hidden="true"></span> Hixson Pike Location Info
                        </div>
                        <div class="lbg_details_content"><?php echo $store['description'] ?></div>
                    <?php } ?>
                    
                    <div class="lbg_details_title">
                        <span class="lbg_arrow far fa-arrow-alt-circle-right" aria-hidden="true"></span> Covid: Please confirm hours
                    </div>
                    <div class="lbg_details_content">
                        <ul class="timming">
                            <?php if($store['is_closed'] == '1'){ ?>
                                <li class="today">
                                    <strong class="text-danger">Closed</strong> | <?php echo $store['close_message'] != '' ? $store['close_message'] : 'Temporarily closed' ?>
                                </li>
                            <?php }else{ ?>
                                <?php foreach ($store['all_time'] as $key => $all_time) { ?>
                                    <li class="<?php echo $all_time['day'] == date('N') ? "today" : '' ?>">
                                        <span class="day_name"> <?php echo date('l', strtotime("Sunday +".$all_time['day']." days")) ?></span>
                                        <span class="day_time">
                                            <?php if($all_time['day'] == date('N')){ ?>
                                                <?php if($store['holiday']['is_holiday'] == true){ ?>
                                                    Time not available
                                                <?php } ?>
                                            <?php } ?> 
                                                <?php $times = json_decode($all_time['time'], true); ?>
                                                <?php foreach ($times as $key => $time) { ?>
                                                    <?php if($time['to'] != '' && $time['from'] != ''){ ?>
                                                        <div><?php echo date('h:i A', strtotime($time['to'])).' - '.date('h:i A', strtotime($time['from'])) ?></div>
                                                    <?php } ?>
                                                <?php } ?>
                                            <?php //} ?>
                                        </span>
                                    </li>
                                <?php } ?>
                            <?php } ?>
                        </ul>
                    </div>

                    <div class="lbg_details_title">
                        <span class="lbg_arrow far fa-arrow-alt-circle-right" aria-hidden="true"></span> Directions
                    </div>
                    <div class="lbg_details_content">
                        <ul class="direction-links" role="menu">
                            <li><a onclick="newWindowOpen('https://www.google.com/maps/dir/?api=1&destination=<?php echo $store['latitude'] ?>,<?php echo $store['longitude'] ?>')" href="javascript:void(0)" id="google_dir"><i class="fa fa-external-link"></i> Google Maps Directions</a></li>
                            <li><a onclick="newWindowOpen('https://www.bing.com/maps?rtp=~pos.<?php echo $store['latitude'] ?>_<?php echo $store['longitude'] ?>')" href="javascript:void(0)"><i class="fa fa-external-link"></i> Bing Maps Directions</a></li>
                        </ul>
                    </div>

                    <div class="lbg_details_title">
                        <span class="lbg_arrow far fa-arrow-alt-circle-right" aria-hidden="true"></span> Website
                    </div>
                    <div class="lbg_details_content">
                        <ul class="direction-links" role="menu">
                            <li><a href="https://<?php echo $store['website'] ?>" target="_blank"><i class="fa fa-external-link"></i> Visit Website</a></li>
                        </ul>
                    </div>

                    <?php if($store['additional_info'] != ''){ ?>
                        <div class="lbg_details_title">
                            <span class="lbg_arrow far fa-arrow-alt-circle-right" aria-hidden="true"></span> Welcome
                        </div>
                        
                        <div class="lbg_details_content video">
                            <?php echo $store['additional_info'] ?>
                        </div>
                    <?php } ?>

                    

                    <?php if($store['categories']){ ?>
                        <div class="lbg_details_title">
                            <span class="lbg_arrow far fa-arrow-alt-circle-right" aria-hidden="true"></span> Hixson Pike Categories
                        </div>
                        <div class="lbg_details_content">
                            <?php foreach($store['categories'] as $category){ ?>
                                <div>
                                    <i class="<?php echo $category['icon'] ?>"></i> <?php echo $category['title'] ?>
                                </div>
                            <?php } ?>
                        </div>
                    <?php } ?>

                    
                </div>
            </div>
        <?php } ?>
    </div>
<?php } ?>
<script type="text/javascript">
    $(document).ready(function(){
        $('.store_area').click(function () {
            $(this).find('.lbg_event_all_details').slideToggle();
        })
    })
    function newWindowOpen(url) {
      window.open(url, "_blank", "toolbar=yes,scrollbars=yes,resizable=yes,top=500,left=500,width=600,height=600");
    }
</script>