<link rel="stylesheet" type="text/css" href="<?php echo base_url('assets/frontend/styles/style_v2.css') ?>">
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="alert alert-danger location_denied">
                <strong>Sorry!</strong> We weren't able to obtain your current location. Please try entering your location menually.
            </div>
        </div>
        <div class="col-md-12">
            <?php if(isset($category_info)){ ?>
                <h4 class="text-center"><span class="product_title"><i class="<?php echo $category_info['icon'] ?>"></i> <?php echo $category_info['title'] ?></span></h4>
            <?php } ?>
            <form role="form" id="loc-form" action="" class="pt-15" accept-charset="utf-8" method="post">
                <input name="latitude" type="hidden" id="form_latitude" value="<?php echo $latitude ?>">
                <input name="longitude" type="hidden" id="form_longitude" value="<?php echo $longitude ?>">
                <input name="postal_code" type="hidden" id="postal_code" value="<?php echo $postal_code ?>">
                <input name="page_no" value="1" type="hidden" />
                <input name="category_id" value="<?php echo isset($category_info) ? $category_info['category_id'] : '' ?>" type="hidden" id="category_id" value="<?php echo $category_id ?>">
                <?php /* if($keyword != ''){ ?>
                    <div class="form-group">
                        <input type="text" class="form-control" id="form_keyword" name="keyword" placeholder="Enter Keyword" value="<?php echo $keyword ?>">
                    </div>
                <?php } ?>

                <div class="input-group">
                    <input type="input" name="location" id="form_location" class="form-control" placeholder="Address or Zip Code" autofocus="autofocus">
                    <span class="input-group-btn">
                        <button class="btn btn-default search-btn" type="button"><i class="fa fa-search"></i>
                        </button>
                        <button class="btn btn-default loc-btn" id="button1" type="button" onClick="getLocation('#loc-form')"><i class="fa fa-crosshairs"></i></button>
                    </span>
                </div> */ ?>
                <div class="row">
                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                        <div class="form-group">
                            <input type="text" class="form-control" id="form_keyword" name="keyword" placeholder="Search Keyword..." value="<?php echo $keyword ?>">
                        </div>
                    </div>
                    <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                        <div class="input-group">
                            <input type="input" name="location" id="form_location" class="form-control" placeholder="Address or Zip Code" autofocus="autofocus">
                            <span class="input-group-btn">
                                <button class="btn btn-default search-btn" type="button"><i class="fa fa-search"></i>
                                </button>
                                <button class="btn btn-default loc-btn" id="button1" type="button" onClick="getLocation('#loc-form')"><i class="fa fa-crosshairs"></i></button>
                            </span>
                        </div>
                    </div>
                </div>
                <!-- multiple geocode result drop down -->
                <div class="dropdown location-dropdown">
                    <a role="button" class=" dropdown-toggle" data-toggle="dropdown"></a>
                    <ul class="dropdown-menu" role="menu" aria-labelledby="dlabel">
                    </ul>
                </div>
            </form>
            <div class="result-set-container">
                <div class="result-options" style="padding: 5px 10px; overflow: auto; display: none;">
                    <div class="btn-group">
                        <button type="button" class="btn btn-sm btn-default back-btn"><i class="fa fa-angle-double-left"></i></button>
                        <button type="button" class="btn btn-sm btn-default forward-btn"><i class="fa fa-angle-double-right"></i> </button>
                        <button type="button" class="btn btn-sm btn-default" data-toggle="modal" data-target="#filter-modal"><i class="fa fa-filter"></i> Filter  </button>
                        <div class="pull-right text-muted btn-sm"><span class="total_items"></span> results in <span class="distance"></span></div>
                    </div>
                </div>
                
                <div class="list-group loc-result-set">
                    <?php if(empty($stores) && $keyword_search == false){ ?>
                        <div class="highlight list-group-item default-item text-center">
                            <p class="list-group-item-text" align="center"><strong>Hixson Pike is attempting to locate you.<br>Please allow location search if asked.</strong><br><br><strong></strong></p>
                            <strong><a href="<?php echo base_url('/locator/keyword') ?>">HD Keyword Search</a></strong><br><br><a href="<?php echo base_url() ?>"><strong>Hixson Pike HOME</strong></a>
                        </div>
                    <?php }else{ ?>
                        <?php echo $this->load->view('frontend/v3/ajax/locator', [ 'stores' => $stores ], true); ?>
                    <?php } ?>
                </div>
            </div>    
        </div>
    </div>
</div>
<div class="ajax-loader">
    <i class="fa fa-circle-o-notch fa-spin"></i>
</div>
<script>

    $(document).ready(function(){
        <?php // from getLocation function we get users default GPS location  ?>
        getLocation('#loc-form');

        <?php // when user type location string then using below function we get users lat-lng ?>
        $('#form_location').on('change', function(){
            //addr_search();
            $('.store_detail').html('');
            $('.loc-result-set').css('opacity', 1);
        });
        
        <?php // on search btn click get user's location and filter store  ?>
        $('.search-btn').on('click', function (e) {
            $('.ajax-loader').show();			
            if($('#form_location').val() == ''){
                errorTost("Enter Location to find store", 'top-center');
                $('.ajax-loader').hide();
                return false;
            }
			addr_search();
        });
    });

    <?php // filter store  ?>
    function findStore(page_no = 1){
        $.ajax({
            context: this,
            type: "POST",
            url: "<?php echo base_url('locator/findStore_v3') ?>?page_no="+page_no,
            data: $('#loc-form').serialize(),
            beforeSend: function () {
                $('.ajax-loader').show();
            },
            success: function (response) {
                // e.preventDefault();
                response = JSON.parse(response);
                $('.loc-result-set').html(response);
                $('.ajax-loader').hide();
            }
        });
    }

    <?php // Get single store detail on clicking on view store btn  ?>
    function getStoreDetail(store_id){
        $.ajax({
            context: this,
            type: "POST",
            url: "<?php echo base_url('locator/storeDetail') ?>",
            data: { store_id: store_id },
            beforeSend: function () {
                $('.ajax-loader').show();
            },
            success: function (response) {
                response = JSON.parse(response);
                $('.loc-result-set').css('opacity', 0);
                $('.store_detail').html(response);
                $('.ajax-loader').hide();
            }
        });
    }
</script>